/*****************************************************************************
 *   extint.c:  Event router for external interrupt C file for NXP LPC29xx 
 *   Family Microprocessors
 *
 *   Copyright(C) 2007, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2007.07.20  ver 1.00    Preliminary version, first Release
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 *****************************************************************************/

#include "LPC29xx.h"                        /* LPC29xx definitions */
#include "type.h"
#include "irq.h"
#include "target.h"
#include "extint.h"

volatile BYTE btn_pressed = FALSE;

/*****************************************************************************
** Function name:		EventRouter_Handler
**
** Descriptions:		Event Router handler for External Interrupts
**
** parameters:			None
** Returned value:		None
** 
*****************************************************************************/
void EXTINT_Handler(void)
{
  DWORD regVal;
										
  regVal = ER_PEND;
  if ( regVal & (1<<6) )
  {
    btn_pressed=TRUE;
    ER_INT_CLR = (1<<6);
  }
  return;
}

/*****************************************************************************
** Function name:		EventRouter_Init
**
** Descriptions:		Initialize event router for external interrupt, 
**						install the event router interrupt handler
**
** parameters:			None
** Returned value:		None
** 
*****************************************************************************/
void EXTINT_Init( void )
{  
  ER_APR &= ~(1<<6);				// EINT6 falling edge
  ER_ATR |= (1<<6);					// EINT6 edge trigger

  // button on P2.26, configured as EXTINT6
  SFSP2_26 = (0x01<<2)|(0x03<<0); 	// Digital no PU and PD, func. 3. 

  ER_INT_CLR = 0x7FFFFFF;
  ER_MASK_CLR = 0x7FFFFFF;

  install_irq( EVT_INT, (void *)EXTINT_Handler, LOWEST_PRIORITY );
  EnableIntReq_IRQ( EVT_INT, ACTIVE_HIGH, LOWEST_PRIORITY );
  ER_MASK_SET |= (1<<6);			// Enable interrupt on EINT6 
  
  return;
}

/******************************************************************************
**                            End Of File
******************************************************************************/
